/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import java.util.Random;
import net.minecraft.world.entity.player.Player;

public class DodgeAnimator
extends Animator {
    private static final Random rand = new Random();
    private boolean notInitialized = true;
    private boolean frontLeg = false;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Dodge.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 6.0f;
        if (phase > 1.0f) {
            return;
        }
        float fadeFactor = 1.0f - phase * phase * phase * phase;
        float factor = this.factorFunc(phase);
        float revision = -MathUtil.lerp(0.0f, 30.0f, factor);
        switch (parkourability.get(Dodge.class).getDodgeDirection()) {
            case Front: {
                transformer.rotateAdditionallyHeadPitch(revision);
                if (this.notInitialized) {
                    this.frontLeg = rand.nextBoolean();
                    this.notInitialized = false;
                }
                if (this.frontLeg) {
                    transformer.rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).end();
                    break;
                }
                transformer.rotateRightLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).end();
                break;
            }
            case Right: {
                transformer.rotateAdditionallyHeadPitch(revision).rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).end();
                break;
            }
            case Left: {
                transformer.rotateAdditionallyHeadPitch(revision).rotateRightLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f, fadeFactor).end();
                break;
            }
            case Back: {
                transformer.rotateAdditionallyHeadPitch(-revision);
                if (this.notInitialized) {
                    this.frontLeg = rand.nextBoolean();
                    this.notInitialized = false;
                }
                if (this.frontLeg) {
                    transformer.rotateRightLeg((float)Math.toRadians(MathUtil.lerp(10.0f, 45.0f, factor)), 0.0f, 0.0f, fadeFactor).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor)), 0.0f, 0.0f, fadeFactor).end();
                    break;
                }
                transformer.rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor)), 0.0f, 0.0f, fadeFactor).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(10.0f, 45.0f, factor)), 0.0f, 0.0f, fadeFactor).end();
            }
        }
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 6.0f;
        if (phase > 1.0f) {
            return;
        }
        float factor = this.factorFunc(phase);
        rotator.startBasedCenter().rotateFrontward((float)(parkourability.get(Dodge.class).getDodgeDirection() == Dodge.DodgeDirection.Back ? -1 : 1) * MathUtil.lerp(0.0f, 30.0f, factor)).end();
    }

    private float factorFunc(float phase) {
        if ((double)phase < 0.5) {
            return 1.0f - 4.0f * MathUtil.squaring(phase - 0.5f);
        }
        return 1.0f - EasingFunctions.SinInOutBySquare(2.0f * (phase - 0.5f));
    }
}

